
#include <i2c.h>

void i2c_init(void)
{
	/* Bus freigeben */
	SDA_DDR &= ~(1<<SDA);
	SCL_DDR &= ~(1<<SCL);
	
	SDA_OUT &= ~(1<<SDA);
	SCL_OUT &= ~(1<<SCL);
}

void i2c_start(void)
{
	// SDA auf Low ziehen
	SDA_DDR |= (1<<SDA);
	delay_T();
	// SCL auf Low ziehen
	SCL_DDR |= (1<<SCL);
	delay_T();
}

void i2c_stop(void)
{
	// SCL freigeben
	SCL_DDR &= ~(1<<SCL);
	delay_T();
	// SDA freigeben
	SDA_DDR &= ~(1<<SDA);
	delay_T();
}

unsigned char i2c_write_byte(unsigned char daten)
{
	unsigned char i, ack;
	
	for (i=0;i<8;i++)
	{
		if (daten & 0x80)
			SDA_DDR &= ~(1<<SDA);		// SDA freigeben -> High
		
		// SCL freigeben
		SCL_DDR &= ~(1<<SCL);
		
		delay_T();
		
		// SCL auf Low ziehen
		SCL_DDR |= (1<<SCL);
		
		// SDA auf Low ziehen
		SDA_DDR |= (1<<SDA);
		
		delay_T();
		
		daten <<= 1;
	}
	
	// SDA freigeben
	SDA_DDR &= ~(1<<SDA);
	// SCL freigeben
	SCL_DDR &= ~(1<<SCL);
	
	delay_T();
	
	// Acknowlegde abfragen
	ack = SDA_IN & (1<<SDA);
	
	// SCL auf Low ziehen
	SCL_DDR |= (1<<SCL);
	
	// SDA auf Low ziehen
	SDA_DDR |= (1<<SDA);
	
	delay_T();
	
	if (ack)
		ack = 1;
	
	return ack;
}

unsigned char i2c_read_byte(void)
{
	unsigned char i, daten = 0;
	
	for (i=0;i<8;i++)
	{	
		daten <<= 1;
		
		// SCL freigeben
		SCL_DDR &= ~(1<<SCL);
		
		delay_T();
		
		if (SDA_IN & (1<<SDA))
			daten |= 1;		// SDA freigeben -> High
		
		// SCL auf Low ziehen
		SCL_DDR |= (1<<SCL);
		
		delay_T();
	}
	
	/* Acknowlegde geben */
	
	// SDA freigeben
	SDA_DDR &= ~(1<<SDA);
	// SCL freigeben
	SCL_DDR &= ~(1<<SCL);
	
	delay_T();
	
	// SCL auf Low ziehen
	SCL_DDR |= (1<<SCL);
	
	delay_T();
	
	return daten;
}

void delay_T(void)
{
	unsigned int zaehler;
	unsigned char us;
	
	for(us=0;us <60;us++)
	{
		zaehler = SYSCLK / 5000000;
		while (zaehler) 
		{
			asm volatile ("nop");
			zaehler--;
		}
	}
}
